/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { FilterSelectDecoratorProperties, FilterSelectExtensionDecoratorProperties } from './filter-select-types';
export declare enum FilterSelectDecoratorPropertiesKeys {
    onCloseFilterSelectDialog = "onCloseFilterSelectDialog",
    onOpenFilterSelectDialog = "onOpenFilterSelectDialog"
}
/**
 * Initializes the decorated member as a [FilterSelect]{@link FilterSelectControlObject} field with the provided properties.
 *
 * @param properties The properties that the [FilterSelect]{@link FilterSelectControlObject} field will be initialized with.
 */
export declare function filterSelectField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: FilterSelectDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function filterSelectFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: FilterSelectExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
//# sourceMappingURL=filter-select-decorator.d.ts.map