import type { ClientNode } from '@sage/xtrem-client';
import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { FilterSelectComponentProps, FilterSelectState, FilterSelectDecoratorProperties } from './filter-select-types';
export declare class FilterSelectComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<FilterSelectDecoratorProperties<any, T>, string, {}, FilterSelectState> {
    private readonly lookupButtonRef;
    private searchText;
    private readonly selectInputRef;
    constructor(props: FilterSelectComponentProps<T>);
    private readonly onInputValueChanged;
    private readonly getSearchTextFromValue;
    private readonly getSelectedItemFromValue;
    private readonly onChangeCallback;
    private readonly getItems;
    private readonly getSelectItemsFromNodes;
    private readonly getSelectItemFromCollectionItem;
    private readonly getLocalizedSuffix;
    private readonly getNewItem;
    private readonly isMobileLookupDialogOpen;
    private readonly isMobileSize;
    private readonly triggerOpenFilterSelectDialogEvent;
    private readonly triggerChangeEvent;
    private readonly onMobileButtonClick;
    private readonly onLookupDialogSelectionFinished;
    private readonly onLookupDialogClose;
    private readonly mobileAutoSelect;
    private readonly onMobileInputChange;
    private readonly onChange;
    private renderMobile;
    private readonly getMinLookupCharacters;
    renderDesktop(): React.ReactNode;
    render(): React.ReactNode;
}
export declare const ConnectedFilterSelectComponent: import("react-redux").ConnectedComponent<typeof FilterSelectComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<FilterSelectComponent<ClientNode>> | undefined;
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedFilterSelectComponent;
//# sourceMappingURL=filter-select-component.d.ts.map