import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FilterEditorControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class FilterEditorDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = FilterEditorControlObject;
    }
}
/**
 * Initializes the decorated member as a [FilterEditor]{@link FilterEditorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [FilterEditor]{@link FilterEditorControlObject} field will be initialized with.
 */
export function filterEditorField(properties) {
    return standardDecoratorImplementation(properties, FilterEditorDecorator, FieldKey.FilterEditor, true);
}
export function filterEditorFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=filter-editor-decorator.js.map