import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { FilterEditorDecoratorProperties, FilterEditorExtensionDecoratorProperties } from './filter-editor-types';
/**
 * Initializes the decorated member as a [FilterEditor]{@link FilterEditorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [FilterEditor]{@link FilterEditorControlObject} field will be initialized with.
 */
export declare function filterEditorField<T extends ScreenExtension<T>>(properties: FilterEditorDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function filterEditorFieldOverride<T extends ScreenExtension<T>>(properties: FilterEditorExtensionDecoratorProperties<T>): (target: T, name: string) => void;
//# sourceMappingURL=filter-editor-decorator.d.ts.map