var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { showToast } from '../../../service/toast-service';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export class FilterEditorControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        parameterMode: 'creation',
        filterParameters: [],
        ...EditableFieldControlObject.defaultUiProperties,
    }; }
    /** Refetches data from the server */
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], FilterEditorControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], FilterEditorControlObject.prototype, "placeholder", void 0);
__decorate([
    ControlObjectProperty()
], FilterEditorControlObject.prototype, "selectedProperties", void 0);
__decorate([
    ControlObjectProperty()
], FilterEditorControlObject.prototype, "filterParameters", void 0);
__decorate([
    ControlObjectProperty()
], FilterEditorControlObject.prototype, "parameterMode", void 0);
__decorate([
    ControlObjectProperty()
], FilterEditorControlObject.prototype, "node", void 0);
//# sourceMappingURL=filter-editor-control-object.js.map