/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode, Dict } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { FilterEditorProperties } from './filter-editor-types';
import type { DefaultPropertyType, FilterParameter } from '@sage/xtrem-ui-components';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export declare class FilterEditorControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FilterEditor, FieldComponentProps<FieldKey.FilterEditor>> {
    static readonly defaultUiProperties: Partial<FilterEditorProperties>;
    /** The helper text underneath the field */
    helperText?: string;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    selectedProperties?: Dict<DefaultPropertyType>;
    filterParameters?: FilterParameter[];
    parameterMode?: 'creation' | 'usage';
    node?: string;
    /** Refetches data from the server */
    refresh(): Promise<void>;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=filter-editor-control-object.d.ts.map