import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedFileComponent = React.lazy(() => import('./file-component'));
export function AsyncConnectedFileComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFileComponent, { ...props })));
}
const FileComponent = React.lazy(() => import('./file-component').then(c => ({ default: c.FileComponent })));
export function AsyncFileComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(FileComponent, { ...props })));
}
//# sourceMappingURL=async-file-component.js.map