import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { DynamicPodDecoratorProperties } from './dynamic-pod-types';
/**
 * Initializes the decorated member as a [DynamicPodDecorator]{@link DynamicPodDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DynamicPodDecorator]{@link DynamicPodDecoratorControlObject} field will be initialized with.
 */
export declare function dynamicPodField<T extends ScreenExtension<T>>(properties: DynamicPodDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function dynamicPodFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<DynamicPodDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=dynamic-pod-decorator.d.ts.map