import React, { useContext, useMemo, useCallback } from 'react';
import { Button as CalendarButton, CalendarStateContext } from 'react-aria-components';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../../service/i18n-service';
export function MonthYearHeaderComponent() {
    const state = useContext(CalendarStateContext);
    const months = useMemo(() => [
        localize('@sage/xtrem-ui/dashboard-month_1', 'January'),
        localize('@sage/xtrem-ui/dashboard-month_2', 'February'),
        localize('@sage/xtrem-ui/dashboard-month_3', 'March'),
        localize('@sage/xtrem-ui/dashboard-month_4', 'April'),
        localize('@sage/xtrem-ui/dashboard-month_5', 'May'),
        localize('@sage/xtrem-ui/dashboard-month_6', 'June'),
        localize('@sage/xtrem-ui/dashboard-month_7', 'July'),
        localize('@sage/xtrem-ui/dashboard-month_8', 'August'),
        localize('@sage/xtrem-ui/dashboard-month_9', 'September'),
        localize('@sage/xtrem-ui/dashboard-month_10', 'October'),
        localize('@sage/xtrem-ui/dashboard-month_11', 'November'),
        localize('@sage/xtrem-ui/dashboard-month_12', 'December'),
    ], []);
    const years = useMemo(() => Array.from({ length: 20 }, (_, index) => state.visibleRange.start.year - 10 + index), [state.visibleRange.start.year]);
    const handleMonthChange = useCallback((ev) => {
        const newDate = state.focusedDate.set({ month: Number(ev.target.value) + 1 });
        state.setFocusedDate(newDate);
    }, [state]);
    const handleYearChange = useCallback((ev) => {
        const newDate = state.focusedDate.set({ year: Number(ev.target.value) });
        state.setFocusedDate(newDate);
    }, [state]);
    return (React.createElement("div", { className: "e-calendar-header" },
        React.createElement("div", { className: "e-month-selector-wrapper" },
            React.createElement(CalendarButton, { className: "navigate-month-button-left", slot: "previous", onPress: () => state.focusPreviousPage() },
                React.createElement(Icon, { className: "navigate-month-icon", type: "chevron_left", fontSize: "small" })),
            React.createElement("select", { value: state.visibleRange.start.month - 1, onChange: handleMonthChange, className: "e-month-selector" }, months.map((monthName, index) => (React.createElement("option", { key: `month-${monthName}`, value: index }, monthName)))),
            React.createElement(CalendarButton, { className: "navigate-month-button-right", slot: "next", onPress: () => state.focusNextPage() },
                React.createElement(Icon, { className: "navigate-month-icon", type: "chevron_right", fontSize: "small" }))),
        React.createElement("select", { value: state.visibleRange.start.year, onChange: handleYearChange, className: "e-year-selector" }, years.map(year => (React.createElement("option", { key: `year-${year}`, value: year }, year))))));
}
//# sourceMappingURL=month-year-header-component.js.map