/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { DatetimeRangeDecoratorProperties, DatetimeRangeExtensionDecoratorProperties } from './datetime-range-types';
/**
 * Initializes the decorated member as a [DatetimeRange]{@link DatetimeRangeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DatetimeRange]{@link DatetimeRangeControlObject} field will be initialized with.
 */
export declare function dateTimeRangeField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: DatetimeRangeDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function dateTimeRangeFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: DatetimeRangeExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
//# sourceMappingURL=datetime-range-decorator.d.ts.map