/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Datetime } from '@sage/xtrem-date-time';
import type { ScreenBase } from '../../../service/screen-base';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { DatetimeRangeValue } from './datetime-range-types';
type AllowableDate = Datetime | Date | string;
export declare class DatetimeRangeControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DatetimeRange, FieldComponentProps<FieldKey.DatetimeRange>> {
    isTimeZoneHidden?: boolean;
    timeZone?: string;
    minDate?: AllowableDate;
    maxDate?: AllowableDate;
    defaultDate?: AllowableDate;
    /** Moves the browser focus to this field */
    focus(): void;
    get value(): DatetimeRangeValue | null;
    set value(value: DatetimeRangeValue | null);
}
export {};
//# sourceMappingURL=datetime-range-control-object.d.ts.map