import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedDatetimeRangeComponent = React.lazy(() => import('./datetime-range-component'));
export function AsyncConnectedDatetimeRangeComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedDatetimeRangeComponent, { ...props })));
}
const DatetimeRangeComponent = React.lazy(() => import('./datetime-range-component').then(c => ({ default: c.DatetimeRangeComponent })));
export function AsyncDatetimeRangeComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(DatetimeRangeComponent, { ...props })));
}
//# sourceMappingURL=async-datetime-range-component.js.map