/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { DateDecoratorProperties } from './date-types';
/**
 * Initializes the decorated member as a [Date]{@link DateControlObject} field with the provided properties
 *
 * @param properties The properties that the [Date]{@link DateControlObject} field will be initialized with
 */
export declare function dateField<T extends ScreenExtension<T>>(properties: DateDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function dateFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<DateDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=date-decorator.d.ts.map