/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { datePropertyValueToDateString } from '@sage/xtrem-date-time';
/**
 * [Field]{@link EditableFieldControlObject} that holds a date value in the YYYY-MM-DD format
 */
export class DateControlObject extends EditableFieldControlObject {
    /** The maximum date value allowed for the date field */
    get maxDate() {
        return this.getResolvedProperty('maxDate');
    }
    /** The maximum date value allowed for the date field */
    set maxDate(newValue) {
        const date = newValue ? datePropertyValueToDateString(newValue) : newValue;
        this.setUiComponentProperties('maxDate', date);
    }
    /** The minimum date value allowed for the date field */
    get minDate() {
        return this.getResolvedProperty('minDate');
    }
    /** The minimum date value allowed for the date field */
    set minDate(newValue) {
        const date = newValue ? datePropertyValueToDateString(newValue) : newValue;
        this.setUiComponentProperties('minDate', date);
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
}
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], DateControlObject.prototype, "placeholder", void 0);
//# sourceMappingURL=date-control-object.js.map