import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedDateComponent = React.lazy(() => import('./date-component'));
export function AsyncConnectedDateComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedDateComponent, { ...props })));
}
const DateComponent = React.lazy(() => import('./date-component').then(c => ({ default: c.DateComponent })));
export function AsyncDateComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(DateComponent, { ...props })));
}
//# sourceMappingURL=async-date-component.js.map