import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ContentTableDecoratorProperties } from './content-table-types';
/**
 * Initializes the decorated member as a [ContentTable]{@link ContentTableControlObject} field with the provided properties
 *
 * @param properties The properties that the [ContentTable]{@link ContentTableControlObject} field will be initialized with
 */
export declare function contentTable<T extends ScreenExtension<T>>(properties: ContentTableDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function contentTableOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<ContentTableDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=content-table-decorator.d.ts.map