/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { DefaultPropertyType } from '@sage/xtrem-ui-components';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { ContentTableProperties } from './content-table-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a multi-line text value
 */
export declare class ContentTableControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.ContentTable, FieldComponentProps<FieldKey.ContentTable>> {
    static readonly defaultUiProperties: Partial<ContentTableProperties>;
    selectedProperties?: Dict<DefaultPropertyType>;
    node?: string;
    /** The helper text underneath the field */
    helperText?: string;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Refetches data from the server */
    refresh(): Promise<void>;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=content-table-control-object.d.ts.map