/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { CheckboxControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class CheckboxDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = CheckboxControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Checkbox]{@link CheckboxControlObject} field with the provided properties
 *
 * @param properties The properties that the [Checkbox]{@link CheckboxControlObject} field will be initialized with
 */
export function checkboxField(properties) {
    return standardDecoratorImplementation(properties, CheckboxDecorator, FieldKey.Checkbox);
}
export function checkboxFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=checkbox-decorator.js.map