import React from 'react';
import { LineChart, Line, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts';
import { formatChartLabel } from '../chart-utils';
export function LineChartComponent({ series, screenId, xAxis, data, legend, height, labelNestedField, locale, }) {
    if (!series) {
        throw new Error('No line chart options provided.');
    }
    const getTickFormatter = React.useCallback((value, index) => {
        const rowValue = data[index];
        return formatChartLabel({ value, nestedField: labelNestedField, locale, rowValue, screenId });
    }, [data, labelNestedField, locale, screenId]);
    const getTooltipLabelFormatter = React.useCallback((value) => {
        return formatChartLabel({ value, nestedField: labelNestedField, locale, rowValue: {}, screenId });
    }, [labelNestedField, locale, screenId]);
    const getTooltipValueFormatter = React.useCallback((value, _name, entry, seriesIndex) => {
        const rowValue = entry.payload;
        const nestedField = series[seriesIndex].seriesNestedField;
        return formatChartLabel({ value, nestedField, locale, rowValue, screenId });
    }, [locale, screenId, series]);
    return (React.createElement(ResponsiveContainer, { width: "100%", height: height },
        React.createElement(LineChart, { data: data },
            React.createElement(CartesianGrid, { strokeDasharray: "3 3" }),
            React.createElement(XAxis, { dataKey: xAxis.key, tickFormatter: getTickFormatter }),
            React.createElement(YAxis, null),
            React.createElement(Tooltip, { formatter: getTooltipValueFormatter, labelFormatter: getTooltipLabelFormatter }),
            legend.enabled && React.createElement(Legend, { verticalAlign: legend.position }),
            series.map(serie => (React.createElement(Line, { dataKey: serie.yKey, name: serie.yName, stroke: serie.stroke, key: serie.yKey, type: "monotone", label: true }))))));
}
//# sourceMappingURL=line-chart-component.js.map