import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ChartControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ChartDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = ChartControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Chart]{@link ChartControlObject} field with the provided properties
 *
 * @param properties The properties that the [Chart]{@link ChartControlObject} field will be initialized with
 */
export function chartField(properties) {
    return standardDecoratorImplementation(properties, ChartDecorator, FieldKey.Chart);
}
export function chartFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=chart-decorator.js.map