import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ChartDecoratorProperties } from './chart-types';
/**
 * Initializes the decorated member as a [Chart]{@link ChartControlObject} field with the provided properties
 *
 * @param properties The properties that the [Chart]{@link ChartControlObject} field will be initialized with
 */
export declare function chartField<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: ChartDecoratorProperties<Extend<T>, NodeType>): (target: T, name: string) => void;
export declare function chartFieldOverride<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: ClickableOverrideDecoratorProperties<ChartDecoratorProperties<Extend<T>, NodeType>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=chart-decorator.d.ts.map