/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { CollectionItem, FieldComponentProps, FieldKey } from '../../types';
import type { ChartProperties } from './chart-types';
export interface InternalChartProperties<CT extends ScreenBase = ScreenBase> extends ChartProperties<CT> {
    /** The GraphQL filter set by the user and applied to the records displayed on the chart */
    activeUserFilter?: GraphQLFilter;
}
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of read-only values and represents them as a chart
 */
export declare class ChartControlObject<CT extends ScreenExtension<CT> = ScreenBase, NodeType extends ClientNode = any> extends ReadonlyFieldControlObject<CT, FieldKey.Chart, FieldComponentProps<FieldKey.Chart, CT, NodeType>> {
    static readonly defaultUiProperties: Partial<ChartProperties>;
    /** Graphql filter that will restrict the records displayed in the chart */
    get filter(): GraphQLFilter<NodeType> | undefined;
    /** Graphql filter that will restrict the records displayed in the chart */
    set filter(filter: GraphQLFilter<NodeType> | undefined);
    /** Chart values */
    get value(): CollectionItem[];
    /** Chart values */
    set value(newValue: CollectionItem[]);
    /** Whether the legend should be hidden */
    isLegendHidden?: boolean;
    refresh(): Promise<void>;
}
//# sourceMappingURL=chart-control-object.d.ts.map