import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { CardControlObject } from './card-control-object';
class CardDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = CardControlObject;
    }
}
/**
 * Initializes the decorated member as a [Card]{@link CardControlObject} field with the provided properties.
 *
 * @param properties The properties that the [Card]{@link CardControlObject} field will be initialized with.
 */
export function cardField(properties) {
    return standardDecoratorImplementation(properties, CardDecorator, FieldKey.Card);
}
export function cardFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=card-decorator.js.map