import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { CardDecoratorProperties } from './card-types';
/**
 * Initializes the decorated member as a [Card]{@link CardControlObject} field with the provided properties.
 *
 * @param properties The properties that the [Card]{@link CardControlObject} field will be initialized with.
 */
export declare function cardField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode>(properties: CardDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function cardFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode>(properties: ChangeableOverrideDecoratorProperties<CardDecoratorProperties<Extend<T>, ReferencedItemType>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=card-decorator.d.ts.map