/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ButtonDecoratorProperties } from './button-types';
/**
 * Initializes the decorated member as a [Button]{@link ButtonControlObject} field with the provided properties
 *
 * @param properties The properties that the [Button]{@link ButtonControlObject} field will be initialized with
 */
export declare function buttonField<T extends ScreenExtension<T>>(properties: ButtonDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function buttonFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<ButtonDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=button-decorator.d.ts.map