/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
 */
export declare class ButtonControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Button, FieldComponentProps<FieldKey.Button>> {
    /** The border color of the button */
    get borderColor(): string | undefined;
    /** The border color of the button */
    set borderColor(newValue: string | undefined);
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=button-control-object.d.ts.map