import type { ButtonProps } from 'carbon-react/esm/components/button';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import * as React from 'react';
import { ReadonlyFieldBaseComponent } from '../field-base-component';
import type { ButtonDecoratorProperties } from './button-types';
export declare class ButtonComponent extends ReadonlyFieldBaseComponent<ButtonDecoratorProperties, string, {
    icon?: IconType;
    buttonType?: ButtonProps['buttonType'];
    isDestructive?: boolean;
    onClick?: () => void;
}> {
    getFocusableElement(element: HTMLElement): HTMLButtonElement | null;
    onClick: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedButtonComponent: import("react-redux").ConnectedComponent<typeof ButtonComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ButtonComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    onClick?: (() => void) | undefined;
    buttonType?: ButtonProps['buttonType'];
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    icon?: IconType | undefined;
    isDestructive?: boolean | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedButtonComponent;
//# sourceMappingURL=button-component.d.ts.map