/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { AggregateControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class AggregateDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = AggregateControlObject;
    }
}
/**
 * Initializes the decorated member as a [Aggregate]{@link AggregateControlObject} field with the provided properties
 *
 * @param properties The properties that the [Aggregate]{@link AggregateControlObject} field will be initialized with
 */
export function aggregateField(properties) {
    return standardDecoratorImplementation(properties, AggregateDecorator, FieldKey.Aggregate);
}
export function aggregateFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=aggregate-decorator.js.map