/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { AggregateDecoratorProperties } from './aggregate-types';
/**
 * Initializes the decorated member as a [Aggregate]{@link AggregateControlObject} field with the provided properties
 *
 * @param properties The properties that the [Aggregate]{@link AggregateControlObject} field will be initialized with
 */
export declare function aggregateField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: AggregateDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function aggregateFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: ClickableOverrideDecoratorProperties<AggregateDecoratorProperties<Extend<T>, ReferencedItemType>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=aggregate-decorator.d.ts.map