/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link AggregateControlObject} that holds a single-line aggregate value
 */
export declare class AggregateControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Aggregate, FieldComponentProps<FieldKey.Aggregate>> {
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /**
     * Number of digits after the numeric field value decimal point.
     * Must be in the range 0 - 20, inclusive.
     */
    scale?: number;
    /** Aggregate to be displayed inline after the field value */
    prefix?: string;
    /** Aggregate to be displayed inline before the field value */
    postfix?: string;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=aggregate-control-object.d.ts.map