/**
 * @packageDocumentation
 * @module root
 * */
import type { StickerExtension } from '../../../types';
import type { PageActionControlObject, StickerProperties } from '../../control-objects';
import type { HasGenericErrorHandler } from '../../field/traits';
export interface StickerDecoratorProperties<CT extends StickerExtension<CT>> extends StickerProperties, HasGenericErrorHandler<CT> {
    /** Business actions available in this page */
    businessActions?: (this: CT) => PageActionControlObject[];
    /** Expression that determines whether the sticker is currently active or not */
    isActive: (this: CT) => boolean | Promise<boolean>;
    /** Function that will be executed immediately after the sticker has been loaded */
    onLoad?: (this: CT) => void;
    /** Function that will be executed immediately before the sticker closes */
    onClose?: (this: CT) => void;
    /** Function that will be executed when the user opens the sticker */
    onOpen?: (this: CT) => void;
    /** Function that will be executed when the page becomes dirty or clean */
    onDirtyStateUpdated?: (this: CT, isDirty: boolean) => void;
}
/**
 * Initializes the decorated member as a [Sticker]{@link StickerControlObject} container with the provided properties
 *
 * @param properties The properties that the [Sticker]{@link StickerControlObject} container will be initialized with
 */
export declare function sticker<CT extends StickerExtension<CT>>(properties: StickerDecoratorProperties<CT>): (ctor: Function) => void;
//# sourceMappingURL=sticker-decorator.d.ts.map