/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import type { ContainerProperties } from '../../abstract-container';
import { AbstractContainer } from '../../abstract-container';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps } from '../../types';
import { ContainerKey } from '../../types';
export interface StickerProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
    /** Metadata field for organizing sticker */
    category?: string;
    /** Sticker icon */
    icon: IconType;
}
export interface IStickerControlObject extends Omit<ContainerControlObjectConstructorProps<ContainerKey.Sticker>, 'elementId'> {
    updateMenuItem: (badgeContent?: string | number) => void;
    dispatchPageValidation: () => Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
}
/**
 * Main [container]{@link AbstractContainer} of each screen. Holds any number of [sections]{@link SectionControlObject}
 * and might define additional parts (e.g. crud actions, business actions, a helper panel, etc.)
 */
export declare class StickerControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Sticker, ContainerComponentProps<ContainerKey.Sticker>> {
    private readonly _updateMenuItem;
    private readonly _dispatchPageValidation;
    constructor(properties: IStickerControlObject);
    /**
     * Triggers the validation rules of all the fields of the page. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    validate(): Promise<string[]>;
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
    updateMenuItem(badgeContent?: string | number): void;
}
//# sourceMappingURL=sticker-control-object.d.ts.map