import type { AccessStatus } from '@sage/xtrem-shared';
import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { PageArticleItem } from '../../../service/layout-service';
import type { UserCustomization } from '../../../service/user-customization';
import { ContextType } from '../../../types';
import type { SectionProperties } from '../../control-objects';
import type { ComponentKey } from '../../types';
import type { PageMode } from '../page/page-types';
export interface SectionComponentExternalProps {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType;
    availableColumns: number;
    isParentDisabled?: boolean;
    /**
     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
     * down the hidden status and mark the hidden inputs not focusable
     * */
    isParentHidden?: boolean;
    accessRule?: AccessStatus;
    hasFooter?: boolean;
}
export interface SectionComponentProps extends SectionComponentExternalProps {
    fieldProperties: SectionProperties;
    browser?: ReduxResponsive;
    pageMode?: PageMode;
    setFieldProperties: (bind: string, state: SectionProperties) => void;
    updateUserCustomization: (userCustomizations: UserCustomization[]) => void;
    firstFieldType?: ComponentKey | null;
}
export declare function SectionComponent(props: SectionComponentProps): React.ReactElement;
export declare const ConnectedSectionComponent: import("react-redux").ConnectedComponent<typeof SectionComponent, {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType | undefined;
    availableColumns: number;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    accessRule?: AccessStatus | undefined;
    hasFooter?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=section-component.d.ts.map