import type { Page } from '../../../service/page';
import type { Constructible, PageExtension } from '../../../types';
import { AbstractDecorator } from '../../abstract-decorator';
import type { ContainerProperties, BlockControlObject } from '../../control-objects';
import type { HasParent } from '../../field/traits';
import type { ContainerKey } from '../../types';
export interface PageFragmentDecoratorProperties<CT extends PageExtension<CT> = PageExtension<any>> extends HasParent<CT, BlockControlObject<CT>>, ContainerProperties<CT> {
    /** Function that will be executed immediately after the page fragment has been loaded */
    onLoad?: (this: CT) => void;
}
export declare class PageFragmentDecorator extends AbstractDecorator<ContainerKey.PageFragment> {
    protected _controlObjectConstructor: any;
}
/**
 * Initializes the decorated member as a [Page]{@link PageFragmentControlObject} container with the provided properties
 *
 * @param properties The properties that the [Page]{@link PageFragmentControlObject} container will be initialized with
 */
export declare function pageFragment<CT extends PageExtension<CT>>(properties: PageFragmentDecoratorProperties<CT>): (ctor: Constructible<Page>) => void;
//# sourceMappingURL=page-fragment-decorator.d.ts.map