/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { PageMetadata } from '../../../service/page-metadata';
import type { PageExtension } from '../../../types';
import type { UiComponentProperties } from '../../abstract-ui-control-object';
import type { PageActionControlObject } from '../../control-objects';
import type { AccessConfiguration } from '../../field/traits';
import type { PageDecoratorProperties } from './page-decorator';
import type { BasePageDecoratorProperties, PageNavigationPanelExtension } from './page-types';
export interface PageExtensionDecoratorProperties<CT extends PageExtension<CT>, NodeType extends ClientNode = any> extends BasePageDecoratorProperties<CT> {
    /** Page that this extension extends in the following format: @sage/package-name/PageName */
    extends: string;
    /** Access binding that determines whether the extension is loaded */
    extensionAccessBinding?: AccessConfiguration;
    /** Navigation panel property overrides */
    navigationPanel?: PageNavigationPanelExtension<CT, NodeType>;
    /** Navigation panel property overrides */
    businessActions?: (this: CT) => PageActionControlObject[];
}
export interface RuntimePageMetadata extends PageMetadata {
    uiComponentProperties: Dict<UiComponentProperties & {
        onLoadAfter: Array<PageDecoratorProperties<any>['onLoad']>;
        onCloseAfter: Array<PageDecoratorProperties<any>['onClose']>;
    }>;
    defaultUiComponentProperties: Dict<UiComponentProperties & {
        onLoadAfter: Array<PageDecoratorProperties<any>['onLoad']>;
        onCloseAfter: Array<PageDecoratorProperties<any>['onClose']>;
    }>;
}
export declare function pageExtension<CT extends PageExtension<CT>, NodeType extends ClientNode = any>(properties: PageExtensionDecoratorProperties<CT, NodeType>): (ctor: Function) => void;
//# sourceMappingURL=page-extension-decorator.d.ts.map