import * as React from 'react';
import type { PageDefinition } from '../../../service/page-definition';
import { ContextType } from '../../../types';
import type { PageComponentProps } from './page-types';
declare class PageComponent extends React.Component<PageComponentProps> {
    private readonly pageBodyRef;
    private shortcutSubscriptions;
    constructor(props: PageComponentProps);
    componentDidMount(): void;
    componentDidCatch(error: Error): void;
    componentWillUnmount(): void;
    getActiveSectionId: () => string | undefined;
    getVisibleSections: () => HTMLDivElement[];
    getActiveSectionIndex(): number;
    onBodyScroll: () => void;
    onFileDrop: (files: FileList) => Promise<void>;
    getPageClassName(): string;
    getPendoPageMode(): string;
    hasPageFooter: () => boolean;
    renderDetailPanel(): React.ReactNode;
    renderSections(availableColumns: number): React.ReactNode;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof PageComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<PageComponent> | undefined;
    availableColumns: number;
    pageDefinition: PageDefinition;
    contextType: ContextType;
    selectedSection?: string | null | undefined;
    noHeader?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=page-component.d.ts.map