import * as React from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { ContextType } from '../../../types';
import BusinessActions from '../footer/business-actions';
import { BusinessAction } from '../footer/business-action';
import * as xtremRedux from '../../../redux';
import { localize } from '../../../service/i18n-service';
import { getVisibleSections } from '../../../utils/layout-utils';
export function PageFooter({ businessActions, screenId, contextType, pageMode, }) {
    const isExtraSmallScreen = useSelector((state) => state.browser.is.xs);
    const dispatch = useDispatch();
    const className = React.useMemo(() => {
        const classes = ['e-page-footer-container'];
        if (contextType) {
            classes.push(`e-page-footer-context-${contextType}`);
        }
        return classes.join(' ');
    }, [contextType]);
    const visibleSections = useSelector((state) => {
        return getVisibleSections(state.screenDefinitions[screenId], {}).map(s => String(s.$containerId));
    });
    const activeSection = useSelector((state) => {
        const pageDefinition = state.screenDefinitions[screenId];
        if (!pageDefinition) {
            return null;
        }
        return pageDefinition.activeSection || visibleSections[0] || null;
    });
    const activeSectionProperties = useSelector((state) => {
        const pageDefinition = state.screenDefinitions[screenId];
        if (!pageDefinition) {
            return null;
        }
        if (!activeSection) {
            return null;
        }
        return pageDefinition.metadata.uiComponentProperties[activeSection];
    });
    const onNextClick = React.useCallback(() => {
        dispatch(xtremRedux.actions.stepOneSection(screenId, 1));
    }, [dispatch, screenId]);
    const onPrevClick = React.useCallback(() => {
        dispatch(xtremRedux.actions.stepOneSection(screenId, 1));
    }, [dispatch, screenId]);
    if ((businessActions && businessActions?.length > 0) || pageMode === 'wizard') {
        return (
        // BL: This element has to be a SPAN for tricky spacing reasons
        React.createElement("span", { className: className },
            React.createElement("div", { className: "e-page-footer" },
                React.createElement(BusinessActions, { businessActions: businessActions, contextType: contextType || ContextType.page, defaultButtonType: "secondary", key: "e-page-footer-business-actions", screenId: screenId, maxMainActions: isExtraSmallScreen ? 2 : 20, pendoId: "pageFooterBusinessActions" }),
                pageMode === 'wizard' && (React.createElement("div", { className: "e-page-footer-wizard-button-wrapper" },
                    activeSection && visibleSections.indexOf(activeSection) !== 0 && (React.createElement("div", { className: "e-page-footer-wizard-button" },
                        React.createElement(BusinessAction, { onClick: onPrevClick, screenId: screenId, pendoId: "wizard-footer-prev-button", title: activeSectionProperties?.wizardPreviousButtonLabel ||
                                localize('@sage/xtrem-ui/wizard-previous', 'Previous') }))),
                    React.createElement("div", { className: "e-page-footer-wizard-button" },
                        React.createElement(BusinessAction, { onClick: onNextClick, screenId: screenId, pendoId: "wizard-footer-next-button", title: activeSectionProperties?.wizardNextButtonLabel ||
                                localize('@sage/xtrem-ui/wizard-next', 'Next'), buttonType: activeSectionProperties?.wizardNextButtonType || 'primary' })))))));
    }
    return null;
}
//# sourceMappingURL=page-footer-component.js.map