import * as React from 'react';
import Switch from 'carbon-react/esm/components/switch';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../../service/i18n-service';
import { useDispatch, useSelector } from 'react-redux';
import { getPageDefinitionFromState, isScreenDefinitionDirty } from '../../../utils/state-utils';
import * as xtremRedux from '../../../redux';
export function Page360Switch({ screenId }) {
    const is360ViewOn = useSelector(state => !!getPageDefinitionFromState(screenId, state)?.is360ViewOn);
    const isDisabled = useSelector(state => isScreenDefinitionDirty(getPageDefinitionFromState(screenId, state)));
    const dispatch = useDispatch();
    const onChange = React.useCallback((ev) => {
        dispatch(xtremRedux.actions.set360ViewState(screenId, ev.target.checked));
    }, [dispatch, screenId]);
    return (React.createElement("div", { className: "e-page-360-switch" },
        React.createElement(Icon, { type: "dashboard", color: "var(--colorsActionMinor500)", marginRight: "8px" }),
        React.createElement("div", { className: "e-page-360-switch-input" },
            React.createElement(Switch, { checked: is360ViewOn, disabled: isDisabled, label: localize('@sage/xtrem-ui/360-view', '360 view'), labelInline: true, onChange: onChange }))));
}
//# sourceMappingURL=page-360-switch.js.map