/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { getStore } from '../../../redux';
import { dispatchFieldsValidation } from '../../../service/dispatch-service';
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { FieldControlObjectResolvedProperty } from '../../property-decorators/control-object-resolved-property-decorator';
import { ContainerKey } from '../../types';
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export class FragmentFieldsControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
    }; }
    constructor(properties) {
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.FragmentFields, properties.getValidationState || (async () => true), properties.layout, properties.parent);
    }
    getFragmentFieldsIds() {
        const fragment = this.uiComponentProperties.fragment.split('/')[2];
        return getStore().getState().screenDefinitions[this.screenId].metadata.fragmentFields[fragment];
    }
    setFieldsFragmentProperty(propertyName, value) {
        const listOfFields = this.getFragmentFieldsIds();
        listOfFields.forEach(fieldId => {
            const properties = this._getUiComponentProperties(this.screenId, fieldId);
            this._setUiComponentProperties(this.screenId, fieldId, { ...properties, [propertyName]: value });
        });
    }
    async validateWithDetails(partition = false) {
        const listOfFieldsIds = this.getFragmentFieldsIds();
        const errors = await dispatchFieldsValidation(listOfFieldsIds, this.screenId);
        return partition ? errors : errors.allErrors;
    }
}
__decorate([
    FieldControlObjectResolvedProperty({
        onSet(_, __, value) {
            this.setFieldsFragmentProperty('isHidden', value);
        },
    })
], FragmentFieldsControlObject.prototype, "isHidden", void 0);
__decorate([
    FieldControlObjectResolvedProperty({
        onSet(_, __, value) {
            this.setFieldsFragmentProperty('isDisabled', value);
        },
    })
], FragmentFieldsControlObject.prototype, "isDisabled", void 0);
//# sourceMappingURL=fragment-fields-control-object.js.map