/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import type { ContainerProperties } from '../../abstract-container';
import { AbstractContainer } from '../../abstract-container';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps, ParentType } from '../../types';
import { ContainerKey } from '../../types';
export interface IFragmentFieldsControlObject extends ContainerControlObjectConstructorProps<ContainerKey.FragmentFields> {
    parent?: ParentType<ContainerKey.FragmentFields>;
}
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export declare class FragmentFieldsControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.FragmentFields, ContainerComponentProps<ContainerKey.FragmentFields>> {
    static readonly defaultUiProperties: Partial<ContainerProperties>;
    constructor(properties: IFragmentFieldsControlObject);
    private getFragmentFieldsIds;
    private setFieldsFragmentProperty;
    isHidden: boolean;
    isDisabled: boolean;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=fragment-fields-control-object.d.ts.map