import * as React from 'react';
import { ContextType } from '../../../types';
import type { PageActionButtonType, PageActionControlObject } from '../../control-objects';
export interface BusinessActionsExternalProps {
    businessActions?: PageActionControlObject[];
    contextType: ContextType;
    defaultButtonType: PageActionButtonType;
    maxMainActions?: number;
    screenId: string;
    pendoId?: string;
}
export interface BusinessActionsProps extends BusinessActionsExternalProps {
    enabledBusinessActions: string[];
    visibleBusinessActions: string[];
}
export declare function BusinessActions(props: BusinessActionsProps): React.ReactElement;
declare const _default: import("react-redux").ConnectedComponent<typeof BusinessActions, {
    businessActions?: PageActionControlObject<import("../../../service/screen-base").ScreenBase<any, any>>[] | undefined;
    contextType: ContextType;
    defaultButtonType: import("carbon-react/esm/components/button/button.component").ButtonTypes | undefined;
    maxMainActions?: number | undefined;
    screenId: string;
    pendoId?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=business-actions.d.ts.map