import Loader from 'carbon-react/esm/components/loader';
import * as React from 'react';
export class LoadingDialog extends React.PureComponent {
    constructor(props) {
        super(props);
        this.timeoutRef = null;
        this.state = { isRendered: false };
    }
    componentDidMount() {
        this.timeoutRef = setTimeout(() => {
            this.timeoutRef = null;
            this.setState({ isRendered: true });
        }, 100);
    }
    componentWillUnmount() {
        if (this.timeoutRef !== null) {
            clearTimeout(this.timeoutRef);
        }
    }
    render() {
        if (this.state.isRendered) {
            return (React.createElement("div", { className: "e-loading-indicator", "data-testid": "e-loading-indicator" },
                React.createElement(Loader, { size: "large" })));
        }
        return null;
    }
}
export default LoadingDialog;
//# sourceMappingURL=loading-dialog.js.map