import { PageControlObject, SectionControlObject } from '../container-control-objects';
import { getVisibleSectionsFromPage } from '../../../utils/state-utils';
export const collectSections = (dialog, screenDefinitions) => {
    const content = dialog.content;
    if (content instanceof PageControlObject && dialog.screenId && screenDefinitions[dialog.screenId]) {
        return getVisibleSectionsFromPage(dialog.screenId, screenDefinitions[dialog.screenId]);
    }
    const allContent = content instanceof Array ? content : [content];
    return allContent.filter(ele => (ele instanceof SectionControlObject && !ele.isHidden) || !(ele instanceof SectionControlObject));
};
//# sourceMappingURL=dialog-utils.js.map