import * as React from 'react';
import { connect } from 'react-redux';
import { ConnectedDialogComponent } from './dialog-component';
export function DialogRouter(props) {
    const isFullScreen = (props.browser && !props.browser.greaterThan.s) || false;
    return (React.createElement(React.Fragment, null, Object.keys(props.activeDialogs).map(dialogKey => (React.createElement(ConnectedDialogComponent, { key: dialogKey, dialogKey: dialogKey, isFullScreen: isFullScreen })))));
}
const mapStateToProps = (state) => ({
    activeDialogs: state.activeDialogs,
    browser: state.browser,
});
export const ConnectedDialogRouter = connect(mapStateToProps)(DialogRouter);
//# sourceMappingURL=dialog-router.js.map