import * as React from 'react';
import { showToast } from '../../../service/toast-service';
import { localize } from '../../../service/i18n-service';
import { copyToClipboard } from '../../../utils/dom';
import { StyledIconButton } from '../../ui/styled-icon-button';
import Link from 'carbon-react/esm/components/link';
import { focusFirstElement } from '../../../utils/layout-utils';
export function DialogErrorContent({ content }) {
    const [isDetailOpen, setDetailOpen] = React.useState(false);
    const onToggleClick = () => setDetailOpen(!isDetailOpen);
    const onCopy = () => {
        copyToClipboard(content.stack ? content.stack.toString() : '');
        showToast(localize('@sage/xtrem-ui/error-detail-copied-to-clipboard', 'Error detail copied to clipboard'), {
            type: 'info',
        });
    };
    const copyErrorDetailsLabel = localize('@sage/xtrem-ui/copy-error-details', 'Copy error details');
    React.useEffect(() => {
        focusFirstElement('.e-dialog-error-content');
    }, []);
    return (React.createElement("div", { className: "e-dialog-error-content", "data-testid": "e-dialog-error-content" },
        React.createElement("p", null, content.message),
        React.createElement("div", { className: "e-dialog-error-header" },
            React.createElement(Link, { "data-testid": "e-dialog-error-details-link", onClick: onToggleClick }, isDetailOpen
                ? localize('@sage/xtrem-ui/hide-technical-details', 'Hide technical details')
                : localize('@sage/xtrem-ui/show-technical-details', 'Show technical details')),
            isDetailOpen && (React.createElement(StyledIconButton, { "data-testid": "e-dialog-error-copy", onClick: onCopy, iconType: "copy", iconTooltipMessage: copyErrorDetailsLabel, "aria-label": copyErrorDetailsLabel, buttonType: "tertiary" }))),
        isDetailOpen && React.createElement("pre", { className: "e-dialog-error-stack" }, content.stack)));
}
//# sourceMappingURL=dialog-error-content.js.map