import Loader from 'carbon-react/esm/components/loader';
import * as React from 'react';
import { DialogErrorContent } from '../dialog-error-content';
import { ConnectedDialogBodyCustomContent } from './custom-content';
import { DialogBodyMessageContent } from './message-content';
import { DialogBodyPageContent } from './page-content';
export function DialogBodyContent(props) {
    if (props.dialog.content instanceof Error) {
        return React.createElement(DialogErrorContent, { content: props.dialog.content });
    }
    // Message dialog
    if (typeof props.dialog.content === 'string') {
        return React.createElement(DialogBodyMessageContent, { ...props });
    }
    // Page dialog
    if (props.dialog.type === 'page' && props.screenDefinition) {
        return React.createElement(DialogBodyPageContent, { ...props });
    }
    // Loading page definition
    if (props.dialog.type === 'page' && !props.screenDefinition) {
        return (React.createElement("div", { className: "e-dialog-content-loading" },
            React.createElement(Loader, { size: "large" })));
    }
    // Custom dialog STUFF
    return (React.createElement(ConnectedDialogBodyCustomContent, { ...props, content: props.dialog.content, screenId: props.dialog.screenId }));
}
//# sourceMappingURL=dialog-body-content.js.map