import { AbstractLayoutBuilder } from '../layouts';
export class DetailPanelLayout extends AbstractLayoutBuilder {
    constructor(target, elementId, nodeTypes, dataTypes, props) {
        super(target, elementId, nodeTypes, dataTypes, props);
        this.target = target;
        this.elementId = elementId;
        this.detailPanelSectionsLayout = [];
        this.detailPanelHeaderLayout = {};
        this.buildLayout = () => {
            const headerElementId = this.detailPanelHeader.id;
            const bodySectionIds = this.detailPanelSections.map(s => s.id);
            this.metadata.pageMetadata.layout.$items = this.metadata.pageMetadata.layout.$items.filter(s => {
                if (headerElementId === s.$containerId) {
                    this.detailPanelHeaderLayout = s;
                    return false;
                }
                if (bodySectionIds.indexOf(s.$containerId) !== -1) {
                    this.detailPanelSectionsLayout.push(s);
                    return false;
                }
                return true;
            });
            this.layout = {
                detailPanelHeaderLayout: this.detailPanelHeaderLayout,
                detailPanelSectionsLayout: this.detailPanelSectionsLayout,
            };
            return this;
        };
        this.detailPanelHeader = props.detailPanelHeader;
        this.detailPanelSections = props.detailPanelSections;
    }
}
//# sourceMappingURL=detail-panel-layout.js.map