/**
 * @packageDocumentation
 * @module root
 * */
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { ContainerKey } from '../../types';
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export class BlockControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
    }; }
    constructor(properties) {
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.Block, properties.getValidationState || (async () => true), properties.layout, properties.parent);
        this.insertBefore = properties.insertBefore;
        this.insertAfter = properties.insertAfter;
        this._dispatchBlockValidation = properties.dispatchBlockValidation;
    }
    /**
     * Triggers the validation rules of all the fields of the block. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    async validate() {
        const result = await this.validateWithDetails();
        return result.map(r => r.message);
    }
    async validateWithDetails(partition = false) {
        const errors = await this._dispatchBlockValidation();
        return partition ? errors : errors.allErrors;
    }
}
//# sourceMappingURL=block-control-object.js.map