import type { CollectionValue } from '../service/collection-data-service';
import * as React from 'react';
import type { Dict } from '@sage/xtrem-shared';
import type { ValidationResult } from '../service/screen-base-definition';
import type { ClientNode } from '@sage/xtrem-client';
interface ConnectedCollectionValueProps {
    value?: CollectionValue;
    isUncommitted?: boolean;
}
/**
 * If a CollectionValue `value` property is provided, the HOC subscribes to the add and remove events of collection value
 * items and re-renders the child component on change
 * @param WrappedComponent
 */
export declare const withCollectionValueSubscription: (WrappedComponent: React.ComponentType<ConnectedCollectionValueProps>) => React.ComponentType;
/**
 * If a CollectionValue `value` property is provided, the HOC subscribes to the add and remove events of collection value
 * items and re-renders the child component on change
 * @param WrappedComponent
 */
export declare const withCollectionValueAndOrderSubscription: (WrappedComponent: React.ComponentType<ConnectedCollectionValueProps>) => React.ComponentType;
export interface ConnectedCollectionItemValueProps extends ConnectedCollectionValueProps {
    recordId?: string;
    level?: number;
    onChange?: (bind: string, value: any, recordId: string) => Promise<void>;
    recordValue?: ClientNode;
    validationState?: Dict<ValidationResult>;
    isUncommitted?: boolean;
    shouldFetchDefault?: boolean;
}
/**
 * If a CollectionValue `value` property and a valid `recordId` property are provided, the HOC subscribes to changes to
 * the item tracked by the record ID and re-renders the child component if the item changes.
 * @param WrappedComponent
 */
export declare const withCollectionValueItemSubscription: <U extends ConnectedCollectionItemValueProps>(WrappedComponent: React.ComponentType<U>) => React.ComponentType<U>;
export {};
//# sourceMappingURL=connected-collection.d.ts.map