var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { cloneDeep } from 'lodash';
import { deepFreeze } from '../utils/common-util';
import { resolveByValue } from '../utils/resolve-value-utils';
import { ContainerControlObjectResolvedProperty } from './property-decorators/control-object-resolved-property-decorator';
/**
 * Any element than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting element's properties values)
 */
export class BaseControlObject {
    static { this.defaultUiProperties = {}; }
    constructor(screenId, elementId, _getUiComponentProperties, _setUiComponentProperties, _componentKey) {
        this.screenId = screenId;
        this.elementId = elementId;
        this._getUiComponentProperties = _getUiComponentProperties;
        this._setUiComponentProperties = _setUiComponentProperties;
        this._componentKey = _componentKey;
    }
    get uiComponentProperties() {
        return this._getUiComponentProperties(this.screenId, this.elementId);
    }
    /**
     * Get and clone the property value to ensure immutability. Function properties are not cloned.
     * @param propertyName
     * @returns deep cloned property value
     */
    getUiComponentProperty(propertyName) {
        const properties = this._getUiComponentProperties(this.screenId, this.elementId);
        const property = properties[propertyName];
        return typeof property === 'function' ? property : cloneDeep(property);
    }
    getResolvedProperty(key, skipHexFormat = true) {
        return resolveByValue({
            screenId: this.screenId,
            propertyValue: this.getUiComponentProperty(key),
            skipHexFormat,
            rowValue: null,
            fieldValue: null,
        });
    }
    /**
     * Clone and then set the property value to ensure immutability. Function properties are not cloned.
     * @param propertyName
     * @param propertyValue
     */
    setUiComponentProperties(propertyName, propertyValue) {
        const state = { ...this.uiComponentProperties };
        state[propertyName] = typeof propertyValue === 'function' ? propertyValue : cloneDeep(propertyValue);
        this._setUiComponentProperties(this.screenId, this.elementId, state);
    }
    /**
     * Only returns a READ-ONLY copy of the properties. Any updates to the object will not affect to the framework.
     */
    get properties() {
        return deepFreeze(cloneDeep(this.uiComponentProperties || {}));
    }
    /** Id of the control object */
    get id() {
        return this.elementId;
    }
    get componentType() {
        return this._componentKey;
    }
}
__decorate([
    ContainerControlObjectResolvedProperty()
    /**
     * Whether the HTML element is editable (disabled = false) or not (disabled = true)
     *
     * The difference with readOnly is that disabled suggests that the field is not editable
     * for some validation reason (e.g. a button which can be clicked due to validation errors)
     */
], BaseControlObject.prototype, "isDisabled", void 0);
//# sourceMappingURL=base-control-object.js.map